StringVal="5e-6"
StringTask="read"
maxlen=512
#"RTE CoLA SST2 MRPC STSB QQP QNLI MNLI"
model_name="main/electralxclip/Epoch01_XATTNBERT"
config_name="google/electra-large-discriminator"
seeds="1" #7
for task in $StringTask; do
	for seed in $seeds; do
		for val in $StringVal; do 
		
			echo ${val}
			OutDir="results/finetune/distil_${model_name}/${task}/lr-"
			OutDir+="${val}"
			OutDir+="-seed-${seed}-maxlen${maxlen}-nosep"
			mkdir -p "$OutDir"
			echo ${OutDir}
			CUDA_VISIBLE_DEVICES=0 PYTHONPATH=$PYTHONPATH:./src python ./src/finetune/distil_run_read.py \
			--task_name ${task} \
			--config_name ${config_name} \
			--tokenizer_name ${config_name} \
			--model_name_or_path "results/pretrain/${model_name}.pth" \
			--xlayers 2 \
			--train_file ./data/commonlitreadabilityprize/train.csv \
			--validation_file ./data/commonlitreadabilityprize/validation.csv \
			--test_file ./data/commonlitreadabilityprize/test.csv \
			--do_train \
			--do_eval \
			--do_predict \
			--learning_rate $val \
			--num_train_epochs 3 \
            --warmup_ratio 0.1 \
			--max_seq_length ${maxlen} \
			--output_dir $OutDir \
			--per_device_eval_batch_size=4 \
			--per_device_train_batch_size=4 \
			--gradient_accumulation_steps 8 \
			--overwrite_output \
			--overwrite_cache \
			--evaluation_strategy epoch \
			--seed ${seed} \
			--save_total_limit 10 \
			--save_steps 79  |& tee "results/finetune/distil_${model_name}/${task}/${task}_lr${val}_seed${seed}-nosep.txt" -i
			#--eval_steps 12 \
			#--logging_steps 12 \
			#--config_name "bert-base-uncased" \
			#--tokenizer_name "bert-base-uncased" \
			#--evaluate_during_training
			#unc-nlp/
		done
	done
done
